cap program drop prog_gentable
program define prog_gentable, eclass
syntax varlist (min = 1 max = 1) , Estimator(string)  Dep(varlist) Fe(string) Clust(varlist) [control(varlist) controls(varlist) chgsample(string) sglt(string)]
qui {
	local EP `=substr("`varlist'", 1, strpos("`varlist'", "_")-1)'
	local dv "`dep'"
	local c `=substr("`control'", 1, strpos("`control'", "_")-1)'
	local fe "`fe'"
	local clus "`clust'"
	local estimator "`estimator'"
	
	local cont = "`c'"+"_post11"
	if "`c'" == "" {
		local cont = ""
	}
	if "`chgsample'" == "yes" {
		local cond_accept = "1"
	}
	else {
		local cond_accept = "$cond_accept"
	}
	local ks = ""
	if "`sglt'" == "keepsingletons" {
		local ks = "keepsingletons"
	}
	
	
	`estimator' `dv' `EP'_post11 `cont' `controls' if `cond_accept'  & insamp,  a(`fe') cl(`clus')  `ks'
		

		local b_`dv' = _b[`EP'_post11]
		local se_`dv' = _se[`EP'_post11]
		local t = `b_`dv''/`se_`dv''
		
		local p_main = 2*ttail(e(df_r), abs(`t'))

		local ereturncoef = `b_`dv''
		local ereturnse = `se_`dv''
		
		if abs(`t') > invttail(e(N), 0.05) {
			local star_`dv' = "*"
		}
		if abs(`t') > invttail(e(N), 0.025) {
			local star_`dv' = "**"
		}
		if abs(`t') > invttail(e(N), 0.005) {
			local star_`dv' = "***"
		}
		local se_`dv' = round(`se_`dv'', 0.0001)
		local b_`dv' = round(`b_`dv'', 0.0001)	
		
		local str =  string(`b_`dv'', "%9.4f") +  "`star_`dv''"+ " (" + string(`se_`dv'', "%9.4f") + ")"
		local ereturnstar =  "`star_`dv''"
		if "`c'" != "" {
			local b_c = _b[`cont']
			local se_c = _se[`cont']
			local str = "`str'" + " [control: "+ string(`b_c', "%9.4f")  + " ("+string(`se_c', "%9.4f")+")] "
			local ereturnctrlb = `b_c'
			local ereturnctrlse = `se_c'
		}
		
		local cont = "`c'"+"_????"
		if "`c'" == "" {
			local cont = ""
		}
		

		`estimator' `dv' `EP'_???? `cont' `controls'  if `cond_accept'  & insamp,  a(`fe') cl(`clus')  `ks'
		matlist e(b)
		matrix b = e(b)
		matrix V = e(V)
		matrix L = J(1, colsof(b), 0)
		forvalues j = 1/6 {
			matrix L[1, `j'] = 1/6
		}
		matrix Tb =  b'
		matrix foo = L*Tb
		scalar avg = foo[1,1]
		matrix TL = L'
		matrix foo = L*V*TL
		scalar var_avg = foo[1, 1]
		scalar se_avg = sqrt(var_avg)
		scalar tstat = avg / se_avg
		if "`estimator'" == "reghdfe" {
			scalar pval = 2*ttail(e(df_r), abs(tstat))
		}
		if "`estimator'" == "ppmlhdfe" {
			scalar pval = 2*ttail(e(df_m), abs(tstat))
		}
		lincom 1/7*(`EP'_2004+`EP'_2005+`EP'_2006+`EP'_2007+`EP'_2008+`EP'_2009)
		local n = e(N)
		local p_`dv' = r(p)
		local se_`dv' = r(se)
		local b_`dv' = r(estimate)
		local t = `b_`dv''/`se_`dv''
		local star_`dv' = ""
		if abs(`t') > invttail(e(N), 0.05) {
			local star_`dv' = "*"	
		}
		if abs(`t') > invttail(e(N), 0.025) {
			local star_`dv' = "**"
		}
		if abs(`t') > invttail(e(N), 0.005) {
			local star_`dv' = "***"
		}
		local p_`dv' = ttail(`n',abs(`t'))
		local p_`dv' = round(pval, 0.001)
		local se_`dv' = round(`se_`dv'', 0.0001)
		local b_`dv' = round(`b_`dv'', 0.0001)	
		distinct gp if e(sample)
		local Nclust =  r(ndistinct)
		local str = "`dv'" +": " + "`str'" + " pretrends: [p=" + string(`p_`dv'', "%9.4f") +  "] | nb_obs "  + string(`n', "%9.0f") + " ("  + string(`Nclust', "%9.0f")+ " pairs)"

		di  in red  "`str'"
}
		ereturn scalar coef = `=round(`ereturncoef', 0.0001)'
		ereturn local star = "`ereturnstar'"
		ereturn local pt = "[p=" + string(`p_`dv'', "%9.3f") +  "]"
		ereturn scalar se = `=round(`ereturnse', 0.0001)'
		ereturn scalar Npairs = `Nclust'
		ereturn scalar Nobs = `n'
		ereturn scalar ctrlcoef = `=round(`ereturnctrlb', 0.0001)'
		ereturn scalar ctrlse = `=round(`ereturnctrlse', 0.0001)'
		ereturn local pm = "[p="+string(`p_main', "%9.3f") + "]"
end